/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import com.equestricraft.logging.Log;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ReflectionHelper {
    private static String scanPackageName = "com.equestricraft";
    private static String scanJarFile = System.getenv("EC_REFLECTION_JAR_PATH");
    private static final List<String> excludePackages = new ArrayList<String>();
    private static final Log log = Log.getLogger(ReflectionHelper.class.getName());

    public static <T extends Annotation> List<Class<?>> scanClassesAnnotatedWith(Class<T> annotation) {
        HashSet classes = new HashSet();
        try {
            for (Class<?> clazz : ReflectionHelper.findAllEquestriCraftClasses()) {
                if (clazz.getAnnotationsByType(annotation).length == 0) continue;
                classes.add(clazz);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            log.error(String.format("Error getting classes annotated with %s", annotation.getName()), ex);
        }
        return new LinkedList(classes);
    }

    public static <T> List<Class<? extends T>> scanClassesImplementingType(Class<? extends T> type) {
        HashSet classes = new HashSet();
        try {
            for (Class<?> clazz : ReflectionHelper.findAllEquestriCraftClasses()) {
                for (Class<?> ifClazz : clazz.getInterfaces()) {
                    if (!ifClazz.equals(type)) continue;
                    classes.add(clazz);
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            log.error(String.format("Error getting classes implementing %s", type.getName()), ex);
        }
        return new LinkedList<Class<? extends T>>(classes);
    }

    public static <T> List<Class<? extends T>> scanClassesExtendingType(Class<? extends T> type) {
        HashSet classes = new HashSet();
        try {
            for (Class<?> clazz : ReflectionHelper.findAllEquestriCraftClasses()) {
                Class<?> superclass = clazz.getSuperclass();
                if (superclass == null || !superclass.equals(type)) continue;
                classes.add(clazz);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            log.error(String.format("Error getting classes extending %s", type.getName()), ex);
        }
        return new LinkedList<Class<? extends T>>(classes);
    }

    public static <T> Class<? extends T> findImplementation(Class<? extends T> clazz) {
        List<Class<T>> classes = ReflectionHelper.scanClassesImplementingType(clazz);
        if (classes.isEmpty()) {
            return null;
        }
        return classes.get(0);
    }

    public static <T extends Annotation> List<Method> scanMethodsAnnotatedWith(Class<T> annotation) {
        HashSet<Method> methods = new HashSet<Method>();
        try {
            for (Class<?> clazz : ReflectionHelper.findAllEquestriCraftClasses()) {
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    methods.add(method);
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            log.error(String.format("Error getting methods annotated with %s", annotation.getName()), ex);
        }
        return new LinkedList<Method>(methods);
    }

    public static <T extends Annotation> List<Field> scanFieldsAnnotatedWith(Class<T> annotation) {
        HashSet<Field> fields = new HashSet<Field>();
        try {
            for (Class<?> clazz : ReflectionHelper.findAllEquestriCraftClasses()) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    fields.add(field);
                }
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            log.error(String.format("Error getting fields annotated with %s", annotation.getName()), ex);
        }
        return new LinkedList<Field>(fields);
    }

    private static Set<Class<?>> findAllEquestriCraftClasses() throws IOException, ClassNotFoundException {
        HashSet classes = new HashSet();
        for (String className : ReflectionHelper.findAllClassNames(scanJarFile)) {
            if (scanPackageName != null && !className.startsWith(scanPackageName) || ReflectionHelper.shouldExcludeClass(className)) continue;
            try {
                classes.add(Class.forName(className));
            }
            catch (Exception ex) {
                log.error(String.format("Error getting class %s", className), ex);
            }
        }
        return classes;
    }

    private static boolean shouldExcludeClass(String className) {
        for (String exclusion : excludePackages) {
            if (!className.startsWith(exclusion)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> findAllClassNames(String jarPath) throws IOException {
        HashSet<String> classNames = new HashSet<String>();
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                String className = jarEntry.getName().replace("WEB-INF/classes/", "").replace("/", ".").replace(".class", "");
                classNames.add(className);
            }
        }
        return classNames;
    }

    public static void setScanPackageName(String packageName) {
        scanPackageName = packageName;
    }

    public static void setScanJarFile(String scanJarFile) {
        ReflectionHelper.scanJarFile = scanJarFile;
    }

    public static void addExclusion(String packageName) {
        excludePackages.add(packageName);
    }

    private ReflectionHelper() {
    }
}

