/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import com.equestricraft.common.util.DateUtils;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutor {
    private static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    public static Task runTaskAt(Date time, Runnable task) {
        long millisecondsUntilRun = DateUtils.millisUntil(time);
        ScheduledFuture<?> f = scheduledExecutorService.schedule(task, millisecondsUntilRun, TimeUnit.MILLISECONDS);
        return new Task(f);
    }

    public static <T> ScheduledFuture<T> runTaskAt(Date time, Callable<T> task) {
        long millisecondsUntilRun = DateUtils.millisUntil(time);
        return scheduledExecutorService.schedule(task, millisecondsUntilRun, TimeUnit.MILLISECONDS);
    }

    private ScheduledExecutor() {
    }

    public static class Task {
        private final ScheduledFuture<?> future;

        public Task(ScheduledFuture<?> future) {
            this.future = future;
        }

        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        public boolean isDone() {
            return this.future.isDone();
        }
    }
}

