/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringCheck {
    private static final Pattern alphaNumericWithSpacesPattern = Pattern.compile("^[a-zA-Z0-9\\s]+$");
    private static final Pattern alphaNumericWithoutSpacesPattern = Pattern.compile("^[a-zA-Z0-9]+$");
    private static final Pattern alphabeticWithSpacesPattern = Pattern.compile("^[a-zA-Z\\s]+$");
    private static final Pattern alphabeticWithoutSpacesPattern = Pattern.compile("^[a-zA-Z]+$");

    public static boolean isAlphanumericWithSpaces(String string) {
        return StringCheck.matchesPattern(string, alphaNumericWithSpacesPattern);
    }

    public static boolean isAlphanumericWithoutSpaces(String string) {
        return StringCheck.matchesPattern(string, alphaNumericWithoutSpacesPattern);
    }

    public static boolean isAlphabeticAllowSpaces(String string) {
        return StringCheck.matchesPattern(string, alphabeticWithSpacesPattern);
    }

    public static boolean isAlphabeticNoSpaces(String string) {
        return StringCheck.matchesPattern(string, alphabeticWithoutSpacesPattern);
    }

    private static boolean matchesPattern(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    private StringCheck() {
    }
}

