/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class TriLock {
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean acquiredExclusively = new AtomicBoolean(false);

    public synchronized void exclusiveLock() {
        this.waitForLockToBecomeAvailable();
        this.acquiredExclusively.set(true);
    }

    public synchronized void sharedLock() {
        this.waitForLockToBecomeAvailable();
    }

    public synchronized boolean conditionalLock() {
        if (this.acquiredExclusively.get()) {
            return false;
        }
        this.waitForLockToBecomeAvailable();
        return true;
    }

    public synchronized void unlock() {
        this.lock.unlock();
        this.acquiredExclusively.set(false);
        this.notify();
    }

    private synchronized void waitForLockToBecomeAvailable() {
        while (this.lock.isLocked() && !this.lock.isHeldByCurrentThread()) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.lock.lock();
    }
}

