/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common;

import java.util.Collection;

public interface UnmodifiableCollection<T>
extends Collection<T> {
    public static final String MESSAGE_CANNOT_MODIFY = "This collection cannot be modified";

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public boolean add(T t) {
        throw new UnsupportedOperationException(MESSAGE_CANNOT_MODIFY);
    }

    @Override
    default public boolean remove(Object o) {
        throw new UnsupportedOperationException(MESSAGE_CANNOT_MODIFY);
    }

    @Override
    default public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException(MESSAGE_CANNOT_MODIFY);
    }

    @Override
    default public boolean containsAll(Collection<?> c) {
        for (Object item : c) {
            if (this.contains(item)) continue;
            return false;
        }
        return true;
    }

    @Override
    default public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(MESSAGE_CANNOT_MODIFY);
    }

    @Override
    default public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(MESSAGE_CANNOT_MODIFY);
    }

    @Override
    default public void clear() {
        throw new UnsupportedOperationException(MESSAGE_CANNOT_MODIFY);
    }

    @Override
    default public <T1> T1[] toArray(T1[] a) {
        return a;
    }
}

