/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.collection;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class FifoFixedSizeQueue<T>
extends AbstractQueue<T> {
    private final Object[] items;
    private int count;

    public FifoFixedSizeQueue(int capacity) {
        this.items = new Object[capacity];
        this.count = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new FifoFixedSizeQueueIterator();
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean offer(T t) {
        Objects.requireNonNull(t, "This queue does not allow null values");
        if (this.count >= this.items.length) {
            this.poll();
        }
        this.items[this.count] = t;
        ++this.count;
        return true;
    }

    @Override
    public T poll() {
        if (this.count <= 0) {
            return null;
        }
        Object item = this.items[0];
        this.shiftLeft();
        --this.count;
        return (T)item;
    }

    private void shiftLeft() {
        for (int i = 1; i < this.items.length && this.items[i] != null; ++i) {
            this.items[i - 1] = this.items[i];
        }
    }

    @Override
    public T peek() {
        if (this.count <= 0) {
            return null;
        }
        return (T)this.items[0];
    }

    public List<T> toList() {
        ArrayList<Object> list = new ArrayList<Object>(this.count);
        for (Object t : this.items) {
            if (t == null) break;
            list.add(t);
        }
        return list;
    }

    private class FifoFixedSizeQueueIterator
    implements Iterator<T> {
        int cursor;
        int lastReturnedElement;

        private FifoFixedSizeQueueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != FifoFixedSizeQueue.this.size();
        }

        @Override
        public T next() {
            int i = this.cursor;
            if (i <= FifoFixedSizeQueue.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] elementData = FifoFixedSizeQueue.this.items;
            if (i >= elementData.length) {
                throw new ConcurrentModificationException();
            }
            this.cursor = i + 1;
            this.lastReturnedElement = i;
            return elementData[i];
        }
    }
}

