/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.collector;

import com.equestricraft.common.collector.MappedSumCollector;
import com.equestricraft.common.util.PercentageUtils;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class ECCollectors {
    public static <T, R extends Number> MappedSumCollector<T, R> toMappedSum(Function<T, R> function) {
        return new MappedSumCollector<T, R>(function);
    }

    public static Collector<Double, ?, Double> toCombinedDoublePercentage() {
        return ECCollectors.toCombinedDoublePercentage(100.0);
    }

    public static Collector<Double, ?, Double> toCombinedDoublePercentage(double base) {
        return Collectors.reducing(base, PercentageUtils::of);
    }

    public static Collector<Float, ?, Float> toCombinedFloatPercentage() {
        return ECCollectors.toCombinedFloatPercentage(1.0f);
    }

    public static Collector<Float, ?, Float> toCombinedFloatPercentage(float base) {
        return Collectors.reducing(Float.valueOf(base), (v, p) -> Float.valueOf(v.floatValue() * p.floatValue()));
    }

    private ECCollectors() {
    }
}

