/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.collector;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class MappedSumCollector<T, R extends Number>
implements Collector<T, List<R>, R> {
    private final Function<T, R> mapper;

    public MappedSumCollector(Function<T, R> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Supplier<List<R>> supplier() {
        return () -> new ArrayList(0);
    }

    @Override
    public BiConsumer<List<R>, T> accumulator() {
        return (numbers, item) -> {
            Number number = (Number)this.mapper.apply(item);
            numbers.add(number);
        };
    }

    @Override
    public BinaryOperator<List<R>> combiner() {
        return (left, right) -> {
            left.addAll(right);
            return left;
        };
    }

    @Override
    public Function<List<R>, R> finisher() {
        return numbers -> {
            double total = 0.0;
            for (Number number : numbers) {
                total = number.doubleValue() + total;
            }
            return total;
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Set.of();
    }
}

