/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.coordinate;

import com.equestricraft.common.coordinate.Point2D;
import java.io.Serializable;

public record Area2D(int x1, int x2, int z1, int z2) implements Serializable
{
    public Area2D {
        if (x1 > x2 || z1 > z2) {
            throw new IllegalArgumentException("Invalid x and z axis bounds defined");
        }
    }

    public int width() {
        return Math.abs(this.x2 - this.x1);
    }

    public int height() {
        return Math.abs(this.z2 - this.z1);
    }

    public int size() {
        return this.width() * this.height();
    }

    public Point2D topLeft() {
        return new Point2D(this.x1, this.z2);
    }

    public Point2D topRight() {
        return new Point2D(this.x2, this.z2);
    }

    public Point2D bottomLeft() {
        return new Point2D(this.x1, this.z1);
    }

    public Point2D bottomRight() {
        return new Point2D(this.x2, this.z1);
    }

    public boolean containsPoint(Point2D point2D) {
        return point2D.x() >= this.x1 && point2D.x() <= this.x2 && point2D.z() >= this.z1 && point2D.z() <= this.z2;
    }

    public boolean overlapsWith(Area2D otherArea) {
        return this.containsPoint(otherArea.topLeft()) || this.containsPoint(otherArea.topRight()) || this.containsPoint(otherArea.bottomLeft()) || this.containsPoint(otherArea.bottomRight()) || otherArea.containsPoint(this.topLeft()) || otherArea.containsPoint(this.topRight()) || otherArea.containsPoint(this.bottomLeft()) || otherArea.containsPoint(this.bottomRight());
    }

    public boolean withinDistanceOf(int distance, Area2D otherArea) {
        int newX1 = otherArea.x1() - distance;
        int newX2 = otherArea.x2() + distance;
        int newZ1 = otherArea.z1() - distance;
        int newZ2 = otherArea.z2() + distance;
        Area2D otherAreaWithGap = new Area2D(newX1, newX2, newZ1, newZ2);
        return this.overlapsWith(otherAreaWithGap);
    }

    public boolean withinDistanceOf(int distance, Point2D point) {
        return this.x1 - distance < point.x() || this.x2 + distance > point.x() && this.z1 - distance < point.z() && this.z2 + distance > point.z();
    }

    public Area2D shiftX(int offset) {
        return new Area2D(this.x1() + offset, this.x2() + offset, this.z1(), this.z2());
    }

    public Area2D shiftZ(int offset) {
        return new Area2D(this.x1(), this.x2(), this.z1() + offset, this.z2() + offset);
    }

    public Area2D transformScale(float factor) {
        return new Area2D((int)((float)this.x1() * factor), (int)((float)this.x2() * factor), (int)((float)this.z1() * factor), (int)((float)this.z2() * factor));
    }
}

