/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.coordinate;

import com.equestricraft.common.coordinate.Area2D;
import com.equestricraft.common.coordinate.Point2D;
import java.util.ArrayList;
import java.util.List;

public class AreaUtility {
    public static Area2D createIntersection(Area2D area1, Area2D area2) {
        int x1 = Math.max(area1.x1(), area2.x1());
        int x2 = Math.min(area1.x2(), area2.x2());
        int z1 = Math.max(area1.z1(), area2.z1());
        int z2 = Math.min(area1.z2(), area2.z2());
        if (x1 > x2 || z1 > z2) {
            throw new IllegalArgumentException("Provided areas do no intersect");
        }
        return new Area2D(x1, x2, z1, z2);
    }

    public static List<Point2D> listOfPointsInArea(Area2D area) {
        ArrayList<Point2D> points = new ArrayList<Point2D>(area.size());
        for (int x = area.x1(); x <= area.x2(); ++x) {
            for (int z = area.z1(); z <= area.z2(); ++z) {
                points.add(new Point2D(x, z));
            }
        }
        return points;
    }

    public static Area2D createAreaFromPointAndRadius(Point2D point, int radius) {
        if (radius < 0) {
            throw new IllegalArgumentException("Radius cannot be negative");
        }
        int x1 = point.x() - radius - 1;
        int x2 = point.x() + radius;
        int z1 = point.z() - radius - 1;
        int z2 = point.z() + radius;
        return new Area2D(x1, x2, z1, z2);
    }

    public static List<Area2D> transformAreasToFit(List<Area2D> areas, int width, int height) {
        Area2D enclosingArea = AreaUtility.buildEnclosingArea(areas);
        int xOffset = -enclosingArea.x1();
        int zOffset = -enclosingArea.z1();
        float scaleFactor = enclosingArea.x2() > enclosingArea.z2() ? (float)((double)width / (double)(enclosingArea.x2() + xOffset)) : (float)((double)height / (double)(enclosingArea.z2() + zOffset));
        return areas.stream().map(a -> a.shiftX(xOffset).shiftZ(zOffset)).map(a -> a.transformScale(scaleFactor)).toList();
    }

    public static Area2D buildEnclosingArea(List<Area2D> areas) {
        if (areas.isEmpty()) {
            throw new IllegalArgumentException("No areas provided");
        }
        Integer left = null;
        Integer right = null;
        Integer top = null;
        Integer bottom = null;
        for (Area2D area : areas) {
            if (left == null || area.x1() < left) {
                left = area.x1();
            }
            if (top == null || area.z1() < top) {
                top = area.z1();
            }
            if (right == null || area.x2() > right) {
                right = area.x2();
            }
            if (bottom != null && area.z2() <= bottom) continue;
            bottom = area.z2();
        }
        return new Area2D(left, right, top, bottom);
    }

    public static Area2D buildAreaFromPoint(Point2D point2D, int radius) {
        return new Area2D(point2D.x() - radius, point2D.x() + radius, point2D.z() - radius, point2D.z() + radius);
    }

    private AreaUtility() {
    }
}

