/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.coordinate;

import com.equestricraft.common.coordinate.Point2D;
import java.io.Serializable;

public record BlockCoordinate(int x, int y, int z, String world) implements Serializable
{
    public BlockCoordinate {
        if (world == null || world.isEmpty()) {
            throw new IllegalArgumentException("Must provide a world name");
        }
    }

    public Point2D getPoint() {
        return new Point2D(this.x, this.z);
    }

    public double distanceTo(BlockCoordinate coordinate) {
        double xSquared = Math.pow(Math.abs(this.x - coordinate.x()), 2.0);
        double zSquared = Math.pow(Math.abs(this.z - coordinate.z()), 2.0);
        double xzDistance = Math.sqrt(xSquared + zSquared);
        double xzSquared = Math.pow(xzDistance, 2.0);
        double ySquared = Math.pow(Math.abs(this.y - coordinate.y()), 2.0);
        return Math.sqrt(xzSquared + ySquared);
    }
}

