/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.coordinate;

import com.equestricraft.common.coordinate.Point2D;
import java.io.Serializable;

public record Coordinate(double x, double y, double z, String world) implements Serializable
{
    public Coordinate {
        if (world == null || world.isEmpty()) {
            throw new IllegalArgumentException("Must provide a world name");
        }
    }

    public Point2D getPoint() {
        return new Point2D((int)this.x, (int)this.z);
    }

    public double distanceTo(Coordinate other) {
        double xDelta = Math.abs(this.x - other.x);
        double yDelta = Math.abs(this.y - other.y);
        double zDelta = Math.abs(this.z - other.z);
        double xy = Math.sqrt(xDelta * xDelta + yDelta * yDelta);
        return Math.sqrt(xy * xy + zDelta * zDelta);
    }
}

