/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.coordinate;

import com.equestricraft.common.coordinate.BlockCoordinate;
import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import java.util.Objects;

public class CoordinateUtility {
    public static DirectionalCoordinate deserializeDirectionalCoordinate(String directionalCoordinateString) {
        Objects.requireNonNull(directionalCoordinateString, "Must supply a directional coordinate string");
        try {
            String[] parts = directionalCoordinateString.split(",");
            if (parts.length != 6) {
                throw new IllegalArgumentException(String.format("Invalid directional coordinate string: %s", directionalCoordinateString));
            }
            double x = Double.parseDouble(parts[0]);
            double y = Double.parseDouble(parts[1]);
            double z = Double.parseDouble(parts[2]);
            String world = parts[3];
            float rotationY = Float.parseFloat(parts[4]);
            float rotationX = Float.parseFloat(parts[5]);
            return new DirectionalCoordinate(x, y, z, world, rotationY, rotationX);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("Error deserializing directional coordinate string: %s", directionalCoordinateString), ex);
        }
    }

    public static String serializeDirectionalCoordinate(DirectionalCoordinate directionalCoordinate) {
        Objects.requireNonNull(directionalCoordinate, "Must supply a directional coordinate");
        return String.format("%s,%s,%s,%s,%s,%s", directionalCoordinate.x(), directionalCoordinate.y(), directionalCoordinate.z(), directionalCoordinate.world(), Float.valueOf(directionalCoordinate.rotationY()), Float.valueOf(directionalCoordinate.rotationX()));
    }

    public static Coordinate deserializeCoordinate(String coordinateString) {
        Objects.requireNonNull(coordinateString, "Must supply a coordinate string");
        try {
            String[] parts = coordinateString.split(",");
            if (parts.length != 4) {
                throw new IllegalArgumentException(String.format("Invalid coordinate string: %s", coordinateString));
            }
            double x = Double.parseDouble(parts[0]);
            double y = Double.parseDouble(parts[1]);
            double z = Double.parseDouble(parts[2]);
            String world = parts[3];
            return new Coordinate(x, y, z, world);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("Error deserializing coordinate string: %s", coordinateString), ex);
        }
    }

    public static String serializeCoordinate(Coordinate coordinate) {
        Objects.requireNonNull(coordinate, "Must supply a coordinate");
        return String.format("%s,%s,%s,%s", coordinate.x(), coordinate.y(), coordinate.z(), coordinate.world());
    }

    public static BlockCoordinate deserializeBlockCoordinate(String blockCoordinateString) {
        Objects.requireNonNull(blockCoordinateString, "Must supply a block coordinate string");
        try {
            String[] parts = blockCoordinateString.split(",");
            if (parts.length != 4) {
                throw new IllegalArgumentException(String.format("Invalid block coordinate string: %s", blockCoordinateString));
            }
            int x = Integer.parseInt(parts[0]);
            int y = Integer.parseInt(parts[1]);
            int z = Integer.parseInt(parts[2]);
            String world = parts[3];
            return new BlockCoordinate(x, y, z, world);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("Error deserializing block coordinate string: %s", blockCoordinateString), ex);
        }
    }

    public static String serializeBlockCoordinate(BlockCoordinate blockCoordinate) {
        Objects.requireNonNull(blockCoordinate, "Must supply a block coordinate");
        return String.format("%s,%s,%s,%s", blockCoordinate.x(), blockCoordinate.y(), blockCoordinate.z(), blockCoordinate.world());
    }

    private CoordinateUtility() {
    }
}

