/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.coordinate;

import java.awt.geom.Path2D;

public class GeometryUtil {
    public static Path2D buildPathFromGeometryString(String geometry) {
        if (geometry.isEmpty()) {
            throw new IllegalArgumentException("Empty geometry string provided");
        }
        Path2D path2D = null;
        try {
            String[] pointStrings;
            for (String pointString : pointStrings = geometry.split(";")) {
                String[] coordinates = pointString.split(",");
                if (coordinates.length != 2) {
                    throw new IllegalArgumentException(String.format("Invalid geometry string provided: %s", geometry));
                }
                double x = Double.parseDouble(coordinates[0]);
                double y = Double.parseDouble(coordinates[1]);
                if (path2D == null) {
                    path2D = new Path2D.Double();
                    path2D.moveTo(x, y);
                    continue;
                }
                path2D.lineTo(x, y);
            }
            if (path2D == null) {
                throw new IllegalArgumentException(String.format("No path could be built from the given geometry string: %s", geometry));
            }
            path2D.closePath();
            return path2D;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException(String.format("Invalid geometry string provided: %s", ex));
        }
    }

    private GeometryUtil() {
    }
}

