/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.genetic;

import java.util.concurrent.ThreadLocalRandom;

public abstract class GeneticValue<T> {
    private final T lowerValue;
    private final T upperValue;

    GeneticValue(T lowerValue, T upperValue) {
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
    }

    GeneticValue(GeneticValue<T> mother, GeneticValue<T> father) {
        this(mother.pickRandom(), father.pickRandom());
    }

    public final T getLowerValue() {
        return this.lowerValue;
    }

    public final T getUpperValue() {
        return this.upperValue;
    }

    public final T pickRandom() {
        return ThreadLocalRandom.current().nextBoolean() ? this.getLowerValue() : this.getUpperValue();
    }
}

