/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.genetic;

import com.equestricraft.common.genetic.GeneticValue;

public class NumericalGeneticValue
extends GeneticValue<Number> {
    private final Number value;

    public NumericalGeneticValue(Number value1, Number value2) {
        super(value1, value2);
        this.value = (value1.doubleValue() + value2.doubleValue()) / 2.0;
    }

    public NumericalGeneticValue(NumericalGeneticValue mother, NumericalGeneticValue father) {
        this((Number)mother.pickRandom(), (Number)father.pickRandom());
    }

    public Number getValue() {
        return this.value;
    }

    public String toString() {
        return "" + this.getValue();
    }

    public static NumericalGeneticValue create(float value) {
        float lower = value / 2.0f;
        float upper = value * 2.0f;
        return new NumericalGeneticValue(Float.valueOf(lower), Float.valueOf(upper));
    }

    public static NumericalGeneticValue create(int value) {
        int lower = value / 2;
        int upper = value * 2;
        return new NumericalGeneticValue(lower, upper);
    }

    public static NumericalGeneticValue create(double value) {
        double lower = value / 2.0;
        double upper = value * 2.0;
        return new NumericalGeneticValue(lower, upper);
    }
}

