/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.height;

import com.equestricraft.common.NumberFormatter;
import com.equestricraft.common.util.LengthUtil;
import java.util.Objects;

public class HorseHeight
implements Comparable<HorseHeight> {
    private final double meters;

    private HorseHeight(double meters) {
        this.meters = meters;
    }

    public double getMeters() {
        return this.meters;
    }

    public double getHands() {
        int inches = (int)Math.round(LengthUtil.cmToInch(this.meters * 100.0));
        int hands = (int)((double)inches / 4.0);
        int remainderInches = inches % 4;
        return Double.parseDouble(hands + "." + remainderInches);
    }

    public String getMetersDisplay() {
        return NumberFormatter.format2DP(this.getMeters()) + "m";
    }

    public String getHandsDisplay() {
        return this.getHands() + "hh";
    }

    @Override
    public int compareTo(HorseHeight o) {
        return Double.compare(this.meters, o.meters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorseHeight that = (HorseHeight)o;
        return Double.compare(that.meters, this.meters) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.meters);
    }

    public String toString() {
        return this.getHandsDisplay();
    }

    public static HorseHeight ofHands(double handsValue) {
        int hands = (int)handsValue;
        int inches = (int)Math.round((handsValue - (double)hands) * 10.0);
        int totalInches = hands * 4 + inches;
        double cm = LengthUtil.inchToCm(totalInches);
        double meters = cm / 100.0;
        return HorseHeight.ofMeters(meters);
    }

    public static HorseHeight ofMeters(double meters) {
        return new HorseHeight(meters);
    }
}

