/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.i18n;

import com.equestricraft.common.i18n.I18nEditRepository;
import com.equestricraft.common.i18n.I18nEntity;
import com.equestricraft.common.i18n.prefix.I18nPrefixEditRepository;
import com.equestricraft.common.i18n.prefix.I18nPrefixEntity;
import com.equestricraft.logging.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public abstract class I18n {
    private static I18n i18n = null;
    private static Map<String, String> resourceMap = new HashMap<String, String>();
    private static Map<String, String> prefixMap = new HashMap<String, String>();
    private static final Log log = Log.getLogger(I18n.class.getName());

    public static void setI18n(I18n i18n) {
        I18n.i18n = i18n;
    }

    public static void load() throws IOException {
        i18n.loadPrefixes();
        i18n.loadResources();
    }

    public static I18n getI18n() {
        return i18n;
    }

    protected abstract I18nEditRepository repository();

    protected abstract I18nPrefixEditRepository prefixRepository();

    private String getLabelImpl(String key) {
        String value = resourceMap.get(key);
        if (value == null) {
            log.warn("Could not find I18n key {}", (Object)key);
            return key;
        }
        return value;
    }

    private String getLabelPrefixImpl(String key) {
        String value = this.getLabelImpl(key);
        Optional<String> prefix = this.findPrefixForKey(key);
        if (prefix.isPresent()) {
            return prefix + " " + value;
        }
        return value;
    }

    private Optional<String> findPrefixForKey(String key) {
        int index = key.indexOf(".");
        if (index == -1) {
            return Optional.empty();
        }
        String pattern = key.substring(0, index);
        String value = prefixMap.get(pattern);
        return Optional.of(value);
    }

    private void loadPrefixes() throws IOException {
        Map<String, String> prefixesFromFile = I18n.loadPrefixesFromFile();
        this.removeUnneededPrefixes(prefixesFromFile);
        List<I18nPrefixEntity> edits = this.prefixRepository().getPrefixEdits();
        for (I18nPrefixEntity edit : edits) {
            prefixesFromFile.put(edit.pattern(), edit.prefix());
        }
        prefixMap = prefixesFromFile;
    }

    private static Map<String, String> loadPrefixesFromFile() throws IOException {
        InputStream stream = I18n.class.getClassLoader().getResourceAsStream("resource-prefixes.properties");
        if (stream == null) {
            throw new FileNotFoundException(String.format("%s not found", "resource-prefixes.properties"));
        }
        Properties props = new Properties();
        props.load(stream);
        HashMap<String, String> fromFile = new HashMap<String, String>();
        props.keySet().forEach(key -> {
            String value = props.getProperty((String)key);
            fromFile.put((String)key, value);
        });
        return fromFile;
    }

    private void removeUnneededPrefixes(Map<String, String> fromFile) {
        Set<String> prefixKeyPatterns = fromFile.keySet();
        int removed = this.prefixRepository().removePrefixesNotInList(prefixKeyPatterns);
        if (removed > 0) {
            log.info("Removed {} unused i18n resource prefixes", (Object)removed);
        }
    }

    private void loadResources() throws IOException {
        HashMap<String, String> resourcesFromFile = I18n.loadResourcesFromFile();
        this.removeUnneededKeys(resourcesFromFile);
        List<I18nEntity> edits = this.repository().getResourceEdits();
        for (I18nEntity edit : edits) {
            resourcesFromFile.put(edit.key(), edit.value());
        }
        resourceMap = resourcesFromFile;
    }

    private static HashMap<String, String> loadResourcesFromFile() throws IOException {
        InputStream stream = I18n.class.getClassLoader().getResourceAsStream("resources.properties");
        if (stream == null) {
            throw new FileNotFoundException(String.format("%s not found", "resources.properties"));
        }
        Properties props = new Properties();
        props.load(stream);
        HashMap<String, String> fromFile = new HashMap<String, String>(props.size());
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> fromFile.put(key.toString(), value.toString())));
        return fromFile;
    }

    private void removeUnneededKeys(HashMap<String, String> fromFile) {
        Set<String> keys2 = fromFile.keySet();
        int removed = this.repository().removeResourcesNotInList(keys2);
        if (removed > 0) {
            log.info("Removed {} unused i18n resource keys", (Object)removed);
        }
    }

    public Map<String, String> getResourceMap() {
        return Collections.unmodifiableMap(resourceMap);
    }

    public void setResourceMap(Map<String, String> resourceMap) {
        I18n.resourceMap = resourceMap;
    }

    public Map<String, String> getPrefixMap() {
        return Collections.unmodifiableMap(prefixMap);
    }

    public void setPrefixMap(Map<String, String> prefixMap) {
        I18n.prefixMap = prefixMap;
    }

    public static String getLabel(String key) {
        return i18n.getLabelImpl(key);
    }

    public static String getLabel(String key, Object ... params) {
        return MessageFormat.format(I18n.getLabel(key), params);
    }

    public static String getLabelWithPrefix(String key) {
        return i18n.getLabelPrefixImpl(key);
    }

    public static String getLabelWithPrefix(String key, Object ... params) {
        return MessageFormat.format(I18n.getLabelWithPrefix(key), params);
    }

    public static Supplier<String> supplyLabel(String key) {
        return () -> I18n.getLabel(key);
    }

    public static Supplier<String> supplyLabel(String key, Object ... params) {
        return () -> I18n.getLabel(key, params);
    }

    public static Supplier<String> supplyLabelWithPrefix(String key) {
        return () -> I18n.getLabelWithPrefix(key);
    }

    public static Supplier<String> supplyLabelWithPrefix(String key, Object ... params) {
        return () -> I18n.getLabel(key, params);
    }
}

