/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.romannumeral;

import com.equestricraft.common.romannumeral.RomanNumeralConverter;
import java.util.Objects;

public final class RomanNumeral
implements Comparable<RomanNumeral> {
    private final int baseNumber;
    private final String numeralValue;

    public RomanNumeral(int baseNumber) {
        this.baseNumber = baseNumber;
        this.numeralValue = RomanNumeralConverter.toRomanNumerals(baseNumber);
    }

    public RomanNumeral(String numeral) {
        this.baseNumber = RomanNumeralConverter.fromRomanNumerals(numeral);
        this.numeralValue = numeral;
    }

    public int getBaseNumber() {
        return this.baseNumber;
    }

    public String getNumeralValue() {
        return this.numeralValue;
    }

    @Override
    public int compareTo(RomanNumeral o) {
        return this.baseNumber - o.baseNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RomanNumeral that = (RomanNumeral)o;
        return this.baseNumber == that.baseNumber;
    }

    public int hashCode() {
        return Objects.hash(this.baseNumber);
    }

    public String toString() {
        return this.getNumeralValue();
    }
}

