/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.romannumeral;

import com.equestricraft.common.romannumeral.RomanNumeralDigit;
import java.util.TreeMap;

public class RomanNumeralConverter {
    private static final TreeMap<Integer, String> numeralsMap = new TreeMap();

    public static String toRomanNumerals(int number) {
        int l = numeralsMap.floorKey(number);
        if (number == l) {
            return numeralsMap.get(number);
        }
        return numeralsMap.get(l) + RomanNumeralConverter.toRomanNumerals(number - l);
    }

    public static int fromRomanNumerals(String numerals) {
        int total = 0;
        int current = 0;
        RomanNumeralDigit lastNumeral = null;
        for (char character : numerals.toCharArray()) {
            RomanNumeralDigit numeral = RomanNumeralDigit.getByCharacter(character);
            if (lastNumeral != null && lastNumeral.lessThan(numeral)) {
                int val = numeral.getValue() - lastNumeral.getValue();
                total += val;
                current = 0;
            } else {
                total += current;
                current = numeral.getValue();
            }
            lastNumeral = numeral;
        }
        return total += current;
    }

    private RomanNumeralConverter() {
    }

    static {
        numeralsMap.put(1000, "M");
        numeralsMap.put(900, "CM");
        numeralsMap.put(500, "D");
        numeralsMap.put(400, "CD");
        numeralsMap.put(100, "C");
        numeralsMap.put(90, "XC");
        numeralsMap.put(50, "L");
        numeralsMap.put(40, "XL");
        numeralsMap.put(10, "X");
        numeralsMap.put(9, "IX");
        numeralsMap.put(5, "V");
        numeralsMap.put(4, "IV");
        numeralsMap.put(1, "I");
    }
}

