/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.romannumeral;

public enum RomanNumeralDigit {
    I(1),
    V(5),
    X(10),
    L(50),
    C(100),
    D(500),
    M(1000);

    private final int value;

    private RomanNumeralDigit(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean greaterThan(RomanNumeralDigit romanNumeralDigit) {
        return this.ordinal() > romanNumeralDigit.ordinal();
    }

    public boolean lessThan(RomanNumeralDigit romanNumeralDigit) {
        return this.ordinal() < romanNumeralDigit.ordinal();
    }

    public static RomanNumeralDigit getByCharacter(char c) {
        for (RomanNumeralDigit numeral : RomanNumeralDigit.values()) {
            if (numeral.name().charAt(0) != Character.toUpperCase(c)) continue;
            return numeral;
        }
        throw new IllegalArgumentException(String.format("Character %s is not a valid roman numeral", Character.valueOf(c)));
    }
}

