/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.season;

import com.equestricraft.common.season.SeasonMeta;
import com.equestricraft.common.season.SeasonType;
import com.equestricraft.common.season.SeasonVisitor;
import com.equestricraft.common.util.DateUtils;
import java.time.Duration;
import java.util.Date;

public abstract class Season {
    private final Date startTime;
    private final Date endTime;

    protected Season(SeasonMeta seasonMeta) {
        long startTimeMillis = 1814400000L * (long)seasonMeta.seasonIndex();
        long endTimeMillis = startTimeMillis + 1814400000L;
        this.startTime = new Date(startTimeMillis);
        this.endTime = new Date(endTimeMillis);
    }

    public abstract SeasonType getType();

    public abstract <T> T accept(SeasonVisitor<T> var1);

    public final Date getStartTime() {
        return this.startTime;
    }

    public final Date getEndTime() {
        return this.endTime;
    }

    public final Duration getDurationSinceStart() {
        return DateUtils.durationSince(this.getStartTime());
    }

    public final Duration getDurationUntilEnd() {
        return DateUtils.durationUntil(this.getEndTime());
    }

    public final float getPercentageThroughSeason() {
        return (float)this.getDurationSinceStart().toMillis() / 1.8144E9f;
    }
}

