/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.season;

import com.equestricraft.common.season.Autumn;
import com.equestricraft.common.season.Season;
import com.equestricraft.common.season.SeasonMeta;
import com.equestricraft.common.season.SeasonType;
import com.equestricraft.common.season.Spring;
import com.equestricraft.common.season.Summer;
import com.equestricraft.common.season.Winter;
import java.util.Date;

public class Seasons {
    private SeasonMeta getSeasonMetaForTime(Date time) {
        int seasonIndexSinceEpoch = this.getSeasonIndexForTime(time);
        int seasonTypeIndex = seasonIndexSinceEpoch % 4;
        SeasonType type = SeasonType.values()[seasonTypeIndex];
        return new SeasonMeta(seasonIndexSinceEpoch, type);
    }

    private int getSeasonIndexForTime(Date time) {
        return (int)(time.getTime() / 1814400000L);
    }

    public Season getCurrentSeason() {
        return this.getSeasonAtTime(new Date());
    }

    public Season getSeasonAtTime(Date time) {
        SeasonMeta meta = this.getSeasonMetaForTime(time);
        return switch (meta.type()) {
            default -> throw new IncompatibleClassChangeError();
            case SeasonType.SPRING -> new Spring(meta);
            case SeasonType.SUMMER -> new Summer(meta);
            case SeasonType.AUTUMN -> new Autumn(meta);
            case SeasonType.WINTER -> new Winter(meta);
        };
    }
}

