/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.util;

public class BinaryUtils {
    public static Boolean[] convertIntegerToBinaryBooleanArray(Integer valueToConvert) {
        return BinaryUtils.convertIntegerToBinaryBooleanArray(valueToConvert, 0);
    }

    public static Boolean[] convertIntegerToBinaryBooleanArray(Integer valueToConvert, int minimumArraySize) {
        String binaryString = Integer.toBinaryString(valueToConvert);
        binaryString = BinaryUtils.ensureLengthIsNotSmallerThanMinimum(binaryString, minimumArraySize);
        char[] binaryCharacterArray = binaryString.toCharArray();
        Boolean[] binaryBooleanArray = new Boolean[binaryCharacterArray.length];
        for (int i = 0; i < binaryCharacterArray.length; ++i) {
            char digit = binaryCharacterArray[i];
            if (digit == '0') {
                binaryBooleanArray[i] = false;
                continue;
            }
            if (digit == '1') {
                binaryBooleanArray[i] = true;
                continue;
            }
            throw new IllegalArgumentException(String.format("Invalid binary digit: %s", Character.valueOf(digit)));
        }
        return binaryBooleanArray;
    }

    private static String ensureLengthIsNotSmallerThanMinimum(String binaryString, int minimum) {
        if (binaryString.length() >= minimum) {
            return binaryString;
        }
        StringBuilder binaryStringBuilder = new StringBuilder(binaryString);
        while (binaryStringBuilder.length() < minimum) {
            binaryStringBuilder.insert(0, "0");
        }
        return binaryStringBuilder.toString();
    }

    public static Integer convertBinaryBooleanArrayToInteger(Boolean[] binaryBooleanArray) {
        char[] binaryCharacterArray = new char[binaryBooleanArray.length];
        for (int i = 0; i < binaryBooleanArray.length; ++i) {
            Boolean booleanValue = binaryBooleanArray[i];
            binaryCharacterArray[i] = Boolean.TRUE.equals(booleanValue) ? 49 : 48;
        }
        String binaryString = new String(binaryCharacterArray);
        return Integer.parseInt(binaryString, 2);
    }

    private BinaryUtils() {
    }
}

