/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.util;

import java.time.Duration;
import java.util.Date;

public class DateUtils {
    public static Duration durationSince(Date time) {
        return DateUtils.durationSince(time.getTime());
    }

    public static Duration durationSince(long time) {
        return Duration.ofMillis(DateUtils.millisSince(time));
    }

    public static long millisSince(Date time) {
        return DateUtils.millisSince(time.getTime());
    }

    public static long millisSince(long time) {
        return DateUtils.millisBetween(time, System.currentTimeMillis());
    }

    public static int secondsSince(Date time) {
        return DateUtils.secondsSince(time.getTime());
    }

    public static int secondsSince(long time) {
        return DateUtils.secondsBetween(time, System.currentTimeMillis());
    }

    public static int minutesSince(Date time) {
        return DateUtils.minutesSince(time.getTime());
    }

    public static int minutesSince(long time) {
        return DateUtils.minutesBetween(time, System.currentTimeMillis());
    }

    public static int hoursSince(Date time) {
        return DateUtils.hoursSince(time.getTime());
    }

    public static int hoursSince(long time) {
        return DateUtils.hoursBetween(time, System.currentTimeMillis());
    }

    public static int daysSince(Date time) {
        return DateUtils.daysSince(time.getTime());
    }

    public static int daysSince(long time) {
        return DateUtils.daysBetween(time, System.currentTimeMillis());
    }

    public static Duration durationUntil(Date time) {
        return DateUtils.durationUntil(time.getTime());
    }

    public static Duration durationUntil(long time) {
        return Duration.ofMillis(DateUtils.millisUntil(time));
    }

    public static long millisUntil(Date time) {
        return DateUtils.millisUntil(time.getTime());
    }

    public static long millisUntil(long time) {
        return DateUtils.millisBetween(System.currentTimeMillis(), time);
    }

    public static int secondsUntil(Date time) {
        return DateUtils.secondsUntil(time.getTime());
    }

    public static int secondsUntil(long time) {
        return DateUtils.secondsBetween(System.currentTimeMillis(), time);
    }

    public static int minutesUntil(Date time) {
        return DateUtils.minutesUntil(time.getTime());
    }

    public static int minutesUntil(long time) {
        return DateUtils.minutesBetween(System.currentTimeMillis(), time);
    }

    public static int hoursUntil(Date time) {
        return DateUtils.hoursUntil(time.getTime());
    }

    public static int hoursUntil(long time) {
        return DateUtils.hoursBetween(System.currentTimeMillis(), time);
    }

    public static int daysUntil(Date time) {
        return DateUtils.daysUntil(time.getTime());
    }

    public static int daysUntil(long time) {
        return DateUtils.daysBetween(System.currentTimeMillis(), time);
    }

    public static Duration durationDifference(Date time) {
        return DateUtils.durationDifference(time.getTime());
    }

    public static Duration durationDifference(long time) {
        return Duration.ofMillis(DateUtils.millisDifference(time));
    }

    public static long millisDifference(Date time) {
        return DateUtils.millisDifference(time.getTime());
    }

    public static long millisDifference(long time) {
        return Math.abs(time - System.currentTimeMillis());
    }

    public static int secondsDifference(Date time) {
        return DateUtils.secondsDifference(time.getTime());
    }

    public static int secondsDifference(long time) {
        return (int)(DateUtils.millisDifference(time) / 1000L);
    }

    public static int minutesDifference(Date time) {
        return DateUtils.minutesDifference(time.getTime());
    }

    public static int minutesDifference(long time) {
        return (int)(DateUtils.millisDifference(time) / 60000L);
    }

    public static int hoursDifference(Date time) {
        return DateUtils.hoursDifference(time.getTime());
    }

    public static int hoursDifference(long time) {
        return (int)(DateUtils.millisDifference(time) / 3600000L);
    }

    public static int daysDifference(Date time) {
        return DateUtils.daysDifference(time.getTime());
    }

    public static int daysDifference(long time) {
        return (int)(DateUtils.millisDifference(time) / 86400000L);
    }

    public static Date futureDurationOffset(Duration offset) {
        return DateUtils.futureMillisOffset(offset.toMillis());
    }

    public static Date futureDurationOffset(Date time, Duration offset) {
        return DateUtils.futureMillisOffset(time, offset.toMillis());
    }

    public static Date futureMillisOffset(long offset) {
        return DateUtils.futureMillisOffset(new Date(), offset);
    }

    public static Date futureMillisOffset(Date time, long offset) {
        return new Date(time.getTime() + offset);
    }

    public static Date futureSecondsOffset(int seconds) {
        return DateUtils.futureSecondsOffset(new Date(), seconds);
    }

    public static Date futureSecondsOffset(Date time, int seconds) {
        return DateUtils.futureMillisOffset(time, (long)seconds * 1000L);
    }

    public static Date futureMinutesOffset(int minutes) {
        return DateUtils.futureMinutesOffset(new Date(), minutes);
    }

    public static Date futureMinutesOffset(Date time, int minutes) {
        return DateUtils.futureMillisOffset(time, (long)minutes * 60000L);
    }

    public static Date futureHoursOffset(int hours) {
        return DateUtils.futureHoursOffset(new Date(), hours);
    }

    public static Date futureHoursOffset(Date time, int hours) {
        return DateUtils.futureMillisOffset(time, (long)hours * 3600000L);
    }

    public static Date futureDaysOffset(int days) {
        return DateUtils.futureDaysOffset(new Date(), days);
    }

    public static Date futureDaysOffset(Date time, int days) {
        return DateUtils.futureMillisOffset(time, (long)days * 86400000L);
    }

    public static boolean isInFuture(Date date) {
        return DateUtils.isInFuture(date.getTime());
    }

    public static boolean isInFuture(long millis) {
        return millis > System.currentTimeMillis();
    }

    public static boolean isInPast(Date date) {
        return DateUtils.isInPast(date.getTime());
    }

    public static boolean isInPast(long millis) {
        return millis < System.currentTimeMillis();
    }

    public static long millisBetween(Date start, Date end) {
        return DateUtils.millisBetween(start.getTime(), end.getTime());
    }

    public static long millisBetween(long start, long end) {
        return end - start;
    }

    public static int secondsBetween(Date start, Date end) {
        return DateUtils.secondsBetween(start.getTime(), end.getTime());
    }

    public static int secondsBetween(long start, long end) {
        return (int)(DateUtils.millisBetween(start, end) / 1000L);
    }

    public static int minutesBetween(Date start, Date end) {
        return DateUtils.minutesBetween(start.getTime(), end.getTime());
    }

    public static int minutesBetween(long start, long end) {
        return (int)(DateUtils.millisBetween(start, end) / 60000L);
    }

    public static int hoursBetween(Date start, Date end) {
        return DateUtils.hoursBetween(start.getTime(), end.getTime());
    }

    public static int hoursBetween(long start, long end) {
        return (int)(DateUtils.millisBetween(start, end) / 3600000L);
    }

    public static int daysBetween(Date start, Date end) {
        return DateUtils.daysBetween(start.getTime(), end.getTime());
    }

    public static int daysBetween(long start, long end) {
        return (int)(DateUtils.millisBetween(start, end) / 86400000L);
    }

    private DateUtils() {
    }
}

