/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class FileUtils {
    public static String getFileContents(String filename) throws IOException {
        InputStream is = FileUtils.getFileAsStream(filename);
        return FileUtils.getFileContents(is);
    }

    private static InputStream getFileAsStream(String fileName) {
        ClassLoader classLoader = FileUtils.class.getClassLoader();
        InputStream inputStream2 = classLoader.getResourceAsStream(fileName);
        if (inputStream2 == null) {
            throw new IllegalArgumentException("file not found! " + fileName);
        }
        return inputStream2;
    }

    private static String getFileContents(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader streamReader = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(streamReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        return sb.toString();
    }

    private FileUtils() {
    }
}

