/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.util;

import com.equestricraft.logging.Log;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    private static final Log log = Log.getLogger(HashUtils.class.getName());

    public static String hex(byte[] array) {
        StringBuffer sb = new StringBuffer();
        for (byte b : array) {
            sb.append(Integer.toHexString(b & 0xFF | 0x100), 1, 3);
        }
        return sb.toString();
    }

    public static String sha256Hex(String message) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return HashUtils.hex(md.digest(message.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            log.error("Error", ex);
            return null;
        }
    }

    private HashUtils() {
    }
}

