/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.util;

import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.WeightedListItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ListUtils {
    @SafeVarargs
    public static <T> List<T> concat(Collection<? extends T> ... collections) {
        LinkedList<? extends T> list = new LinkedList<T>();
        for (Collection<? extends T> c : collections) {
            list.addAll(c);
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> concatDistinct(Collection<? extends T> ... collections) {
        return Stream.of(collections).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public static <T> List<T> ensureList(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... t) {
        return Stream.of(t).collect(Collectors.toList());
    }

    public static <T> List<T> listCopy(Collection<? extends T> collection) {
        if (Objects.isNull(collection)) {
            return Collections.emptyList();
        }
        return new LinkedList<T>(collection);
    }

    public static <T> boolean removeFirstOccurrence(List<? extends T> list, Predicate<? super T> condition) {
        Objects.requireNonNull(list, "Must supply a list");
        Objects.requireNonNull(condition, "Must supply a condition");
        for (int i = 0; i < list.size(); ++i) {
            T t = list.get(i);
            if (!condition.test(t)) continue;
            list.remove(t);
            return true;
        }
        return false;
    }

    public static <T> int removeAllOccurrences(List<? extends T> list, Predicate<? super T> condition) {
        Objects.requireNonNull(list, "Must supply a list");
        Objects.requireNonNull(condition, "Must supply a condition");
        Iterator<T> iterator2 = list.iterator();
        int removed = 0;
        while (iterator2.hasNext()) {
            T t = iterator2.next();
            if (!condition.test(t)) continue;
            iterator2.remove();
            ++removed;
        }
        return removed;
    }

    public static <T> T getRandomItem(List<? extends T> list) {
        Objects.requireNonNull(list, "Must supply a list");
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Provided list must not be empty");
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(list.size());
        return list.get(randomIndex);
    }

    public static <T> T getRandomWeightedItem(List<? extends T> list, ToIntFunction<T> weightValueProvider) {
        Objects.requireNonNull(list, "Must supply a list");
        Objects.requireNonNull(weightValueProvider, "Must supply a provider");
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Provided list must not be empty");
        }
        AtomicInteger currentWeight = new AtomicInteger(0);
        record WeightItem<T>(T t, int weight) {
        }
        List<WeightItem> weightedItems = list.stream().map(t -> {
            int weight = weightValueProvider.applyAsInt(t);
            currentWeight.addAndGet(weight);
            return new WeightItem<Object>(t, currentWeight.get());
        }).toList();
        if (currentWeight.get() == 0) {
            return ListUtils.getRandomItem(list);
        }
        int randomWithinWeightRange = NumberUtils.randomIntInRange(1, currentWeight.get());
        return (T)weightedItems.stream().filter(i -> i.weight() >= randomWithinWeightRange).findFirst().map(WeightItem::t).orElseThrow();
    }

    public static <T extends WeightedListItem> T getRandomWeightedItem(List<? extends T> list) {
        Objects.requireNonNull(list, "Must supply a list");
        return (T)ListUtils.getRandomWeightedItem(list, WeightedListItem::getWeight);
    }

    @SafeVarargs
    public static <T> T getRandom(T ... t) {
        if (t.length == 0) {
            return null;
        }
        List<T> list = ListUtils.asList(t);
        return ListUtils.getRandomItem(list);
    }

    public static String[] listToArray(List<String> list) {
        Objects.requireNonNull(list, "Must supply a list");
        return list.toArray(new String[0]);
    }

    public static <T, R> boolean containsMapping(List<T> list, Function<T, R> function, R value) {
        LinkedList<R> mappedList = new LinkedList<R>();
        for (T t : list) {
            mappedList.add(function.apply(t));
        }
        return mappedList.contains(value);
    }

    public static <T> boolean containsByPredicate(List<T> list, Predicate<T> predicate) {
        for (T item : list) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public static <T> Optional<T> singletonOptional(List<T> list) {
        return Optional.ofNullable(list != null && list.size() == 1 ? (Object)list.get(0) : null);
    }

    public static <T> List<T> sortedSublistKeepTiedItems(List<T> list, Comparator<T> comparator, int targetSize) {
        if (targetSize == 0) {
            return Collections.emptyList();
        }
        if (targetSize >= (list = list.stream().sorted(comparator).toList()).size()) {
            return list;
        }
        ArrayList<Object> toReturn = new ArrayList<Object>(targetSize);
        Object lastAddedItem = null;
        for (Object item : list) {
            if (toReturn.size() < targetSize) {
                toReturn.add(item);
            } else {
                if (comparator.compare(lastAddedItem, item) != 0) break;
                toReturn.add(item);
            }
            lastAddedItem = item;
        }
        return Collections.unmodifiableList(toReturn);
    }

    public static <T> Optional<T> findLastMatch(List<T> list, Predicate<T> predicate) {
        ArrayList<T> listCopy = new ArrayList<T>(list);
        Collections.reverse(listCopy);
        return listCopy.stream().filter(predicate).findFirst();
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return !collection.isEmpty();
    }

    public static <T> List<List<T>> batch(Collection<T> collection, int batchSize) {
        ArrayList<List<T>> batches = new ArrayList<List<T>>();
        ArrayList<T> currentList = new ArrayList<T>(batchSize);
        for (T item : collection) {
            currentList.add(item);
            if (currentList.size() < batchSize) continue;
            batches.add(currentList);
            currentList = new ArrayList(batchSize);
        }
        return batches;
    }

    private ListUtils() {
    }
}

