/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.util;

import com.equestricraft.common.coordinate.DirectionalCoordinate;

public class LocationUtils {
    public static double calculateDistance(DirectionalCoordinate location1, DirectionalCoordinate location2) {
        if (!location1.world().equals(location2.world())) {
            throw new IllegalArgumentException("Locations must be in the same world");
        }
        double xDelta = location2.x() - location1.x();
        double yDelta = location2.y() - location1.y();
        double zDelta = location2.z() - location1.z();
        double powerTotal = Math.pow(xDelta, 2.0) + Math.pow(yDelta, 2.0) + Math.pow(zDelta, 2.0);
        return Math.sqrt(powerTotal);
    }

    private LocationUtils() {
    }
}

