/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MapUtils {
    public static <K, V> Map<K, V> createMap(Collection<V> collection, Function<V, K> keyFunction) {
        return MapUtils.createMap(collection, keyFunction, Function.identity());
    }

    public static <T, K, V> Map<K, V> createMap(Collection<T> collection, Function<T, K> keyFunction, Function<T, V> valueFunction) {
        HashMap map = new HashMap(0);
        collection.forEach(c -> map.put(keyFunction.apply(c), valueFunction.apply(c)));
        return map;
    }

    public static <K> void safeAdd(Map<K, Integer> map, K key) {
        MapUtils.safeAdd(map, key, 1);
    }

    public static <K> void safeAdd(Map<K, Integer> map, K key, Integer toAdd) {
        if (map.containsKey(key)) {
            map.put(key, map.get(key) + toAdd);
        } else {
            map.put(key, toAdd);
        }
    }

    public static <K, V> void safeListAdd(Map<K, List<V>> map, K key, V value) {
        if (map.containsKey(key)) {
            List<V> list = map.get(key);
            list.add(value);
        } else {
            ArrayList<V> list = new ArrayList<V>(1);
            list.add(value);
            map.put(key, list);
        }
    }

    public static <K, V> void safeListAdd(Map<K, List<V>> map, K key, List<V> values2) {
        if (map.containsKey(key)) {
            List<V> list = map.get(key);
            list.addAll(values2);
        } else {
            ArrayList<V> list = new ArrayList<V>(values2);
            map.put(key, list);
        }
    }

    private MapUtils() {
    }
}

