/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public class NumberUtils {
    private static final String MSG_MUST_SUPPLY_VALUE = "Must supply a value";
    private static final String MSG_MINIMUM_BIGGER_THAN_MAXIMUM = "Minimum %s is bigger than maximum %s";

    public static int nextInt() {
        return ThreadLocalRandom.current().nextInt();
    }

    public static double nextDouble() {
        return ThreadLocalRandom.current().nextDouble();
    }

    public static int nextInt(int bound) {
        return ThreadLocalRandom.current().nextInt(bound);
    }

    public static double nextDouble(double bound) {
        return ThreadLocalRandom.current().nextDouble(bound);
    }

    public static int randomIntInRange(int minimum, int maximum) {
        return ThreadLocalRandom.current().nextInt(minimum, maximum + 1);
    }

    public static double randomDoubleInRange(double minimum, double maximum) {
        return ThreadLocalRandom.current().nextDouble(minimum, maximum);
    }

    public static float randomFloatInRange(float minimum, float maximum) {
        return ThreadLocalRandom.current().nextFloat(minimum, maximum);
    }

    public static long randomLongInRange(long minimum, long maximum) {
        return ThreadLocalRandom.current().nextLong(minimum, maximum);
    }

    public static float nextFloat() {
        return ThreadLocalRandom.current().nextFloat();
    }

    public static float nextFloat(float bound) {
        return ThreadLocalRandom.current().nextFloat(bound);
    }

    public static int averageInts(Collection<Integer> numbers) {
        if (numbers == null || numbers.isEmpty()) {
            return 0;
        }
        int total = NumberUtils.addIntegers(numbers);
        return total / numbers.size();
    }

    public static double averageDoubles(Collection<Double> numbers) {
        if (numbers == null || numbers.isEmpty()) {
            return 0.0;
        }
        double total = NumberUtils.addDoubles(numbers);
        return total / (double)numbers.size();
    }

    public static float averageFloats(Collection<Float> numbers) {
        if (numbers == null || numbers.isEmpty()) {
            return 0.0f;
        }
        float total = NumberUtils.addFloats(numbers);
        return total / (float)numbers.size();
    }

    public static long averageLongs(Collection<Long> numbers) {
        if (numbers == null || numbers.isEmpty()) {
            return 0L;
        }
        float total = NumberUtils.addLongs(numbers);
        return (long)(total / (float)numbers.size());
    }

    public static int average(int ... numbers) {
        if (numbers.length == 0) {
            return 0;
        }
        int total = NumberUtils.add(numbers);
        return total / numbers.length;
    }

    public static double average(double ... numbers) {
        if (numbers.length == 0) {
            return 0.0;
        }
        double total = NumberUtils.add(numbers);
        return total / (double)numbers.length;
    }

    public static float average(float ... numbers) {
        if (numbers.length == 0) {
            return 0.0f;
        }
        float total = NumberUtils.add(numbers);
        return total / (float)numbers.length;
    }

    public static long average(long ... numbers) {
        if (numbers.length == 0) {
            return 0L;
        }
        long total = NumberUtils.add(numbers);
        return total / (long)numbers.length;
    }

    public static int addIntegers(Collection<Integer> numbers) {
        return numbers.stream().reduce(Integer::sum).orElse(0);
    }

    public static double addDoubles(Collection<Double> numbers) {
        return numbers.stream().reduce(Double::sum).orElse(0.0);
    }

    public static float addFloats(Collection<Float> numbers) {
        return numbers.stream().reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static float addLongs(Collection<Long> numbers) {
        return numbers.stream().reduce(Long::sum).orElse(0L).longValue();
    }

    public static int add(int ... numbers) {
        int total = 0;
        for (int number : numbers) {
            total += number;
        }
        return total;
    }

    public static double add(double ... numbers) {
        double total = 0.0;
        for (double number : numbers) {
            total += number;
        }
        return total;
    }

    public static float add(float ... numbers) {
        float total = 0.0f;
        for (float number : numbers) {
            total += number;
        }
        return total;
    }

    public static long add(long ... numbers) {
        long total = 0L;
        for (long number : numbers) {
            total += number;
        }
        return total;
    }

    public static boolean testProbability(int probabilityPercentage) {
        int random = NumberUtils.nextInt(100);
        return random < probabilityPercentage;
    }

    public static boolean testProbability(float probabilityPercentage) {
        float random = NumberUtils.nextFloat(100.0f);
        return random < probabilityPercentage;
    }

    public static boolean testProbability(double probabilityPercentage) {
        double random = NumberUtils.nextDouble(100.0);
        return random < probabilityPercentage;
    }

    public static boolean isWholeNumber(double number) {
        return number % 1.0 == 0.0;
    }

    public static boolean isNumeric(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static Integer keepWithinRange(Integer value, Integer minimum, Integer maximum) {
        Objects.requireNonNull(value, MSG_MUST_SUPPLY_VALUE);
        minimum = minimum != null ? minimum : Integer.MIN_VALUE;
        maximum = maximum != null ? maximum : Integer.MAX_VALUE;
        if (maximum < minimum) {
            throw new IllegalArgumentException(String.format(MSG_MINIMUM_BIGGER_THAN_MAXIMUM, minimum, maximum));
        }
        return Math.min(Math.max(value, minimum), maximum);
    }

    public static Float keepWithinRange(Float value, Float minimum, Float maximum) {
        Objects.requireNonNull(value, MSG_MUST_SUPPLY_VALUE);
        minimum = Float.valueOf(minimum != null ? minimum.floatValue() : Float.MIN_VALUE);
        maximum = Float.valueOf(maximum != null ? maximum.floatValue() : Float.MAX_VALUE);
        if (maximum.floatValue() < minimum.floatValue()) {
            throw new IllegalArgumentException(String.format(MSG_MINIMUM_BIGGER_THAN_MAXIMUM, minimum, maximum));
        }
        return Float.valueOf(Math.min(Math.max(value.floatValue(), minimum.floatValue()), maximum.floatValue()));
    }

    public static Double keepWithinRange(Double value, Double minimum, Double maximum) {
        Objects.requireNonNull(value, MSG_MUST_SUPPLY_VALUE);
        minimum = minimum != null ? minimum : Double.MIN_VALUE;
        maximum = maximum != null ? maximum : Double.MAX_VALUE;
        if (maximum < minimum) {
            throw new IllegalArgumentException(String.format(MSG_MINIMUM_BIGGER_THAN_MAXIMUM, minimum, maximum));
        }
        return Math.min(Math.max(value, minimum), maximum);
    }

    public static Long keepWithinRange(Long value, Long minimum, Long maximum) {
        Objects.requireNonNull(value, MSG_MUST_SUPPLY_VALUE);
        minimum = minimum != null ? minimum : Long.MIN_VALUE;
        maximum = maximum != null ? maximum : Long.MAX_VALUE;
        if (maximum < minimum) {
            throw new IllegalArgumentException(String.format(MSG_MINIMUM_BIGGER_THAN_MAXIMUM, minimum, maximum));
        }
        return Math.min(Math.max(value, minimum), maximum);
    }

    public static Integer min(int ... value) {
        return Arrays.stream(value).min().orElseThrow();
    }

    public static Double min(double ... value) {
        return Arrays.stream(value).min().orElseThrow();
    }

    public static Long min(long ... value) {
        return Arrays.stream(value).min().orElseThrow();
    }

    public static Integer max(int ... value) {
        return Arrays.stream(value).max().orElseThrow();
    }

    public static Double max(double ... value) {
        return Arrays.stream(value).max().orElseThrow();
    }

    public static Long max(long ... value) {
        return Arrays.stream(value).max().orElseThrow();
    }

    private NumberUtils() {
    }
}

