/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.util;

import java.util.function.Function;
import java.util.function.Supplier;

public class ObjectUtils {
    public static <T, R> R nullable(T object, Function<T, R> function) {
        return (R)ObjectUtils.nullable(object, function, () -> null);
    }

    public static <T> T nullable(T object, Supplier<T> defaultValueSupplier) {
        return ObjectUtils.nullable(object, Function.identity(), defaultValueSupplier);
    }

    public static <T, R> R nullable(T object, Function<T, R> function, Supplier<R> defaultValueSupplier) {
        return object != null ? function.apply(object) : defaultValueSupplier.get();
    }

    public static <T, I extends T, R> R castMap(T t, Class<? extends I> clazz, Function<I, R> function) {
        I i = clazz.cast(t);
        return function.apply(i);
    }

    private ObjectUtils() {
    }
}

