/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.util;

import com.equestricraft.common.util.NumberUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class StringUtils {
    public static final String EMPTY_STRING = "";

    public static String argsToString(String[] args2) {
        Objects.requireNonNull(args2, "Must supply an array");
        return StringUtils.argsToString(args2, 0);
    }

    public static String argsToString(String[] args2, int start) {
        Objects.requireNonNull(args2, "Must supply an array");
        StringBuilder builder = new StringBuilder();
        for (int i = start; i < args2.length; ++i) {
            String s = args2[i];
            builder.append(s).append(" ");
        }
        return builder.toString().trim();
    }

    public static String capitaliseString(String string) {
        string = string.replace("_", " ");
        string = string.toLowerCase();
        StringBuilder builder = new StringBuilder();
        char[] charArray = string.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (i == 0) {
                builder.append(Character.toUpperCase(c));
                continue;
            }
            char prev = charArray[i - 1];
            if (Character.isWhitespace(prev)) {
                builder.append(Character.toUpperCase(c));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String emptyString() {
        return EMPTY_STRING;
    }

    public static boolean isNotEmpty(String string) {
        return !string.isEmpty();
    }

    public static boolean isNotBlank(String string) {
        return !string.isBlank();
    }

    public static String oxfordCommandSeparate(List<String> strings) {
        if (strings.isEmpty()) {
            return StringUtils.emptyString();
        }
        if (strings.size() == 1) {
            return strings.get(0);
        }
        String string = String.join((CharSequence)", ", strings);
        int indexOfLastComma = string.lastIndexOf(44);
        if (strings.size() > 2) {
            ++indexOfLastComma;
        }
        String part1 = string.substring(0, indexOfLastComma);
        if (strings.size() == 2) {
            ++indexOfLastComma;
        }
        String part2 = string.substring(indexOfLastComma);
        return String.format("%s and%s", part1, part2);
    }

    public static String safeStartOfString(String string, int maximumCharacters) {
        if (string.length() <= maximumCharacters) {
            return string;
        }
        string = string.substring(0, maximumCharacters - 1);
        return string + "\u2026";
    }

    public static String scrambleNoMixingWords(String word) {
        String[] words = word.split(" ");
        ArrayList<String> results = new ArrayList<String>();
        for (String w : words) {
            String scrambled = StringUtils.scramble(w);
            results.add(scrambled);
        }
        return String.join((CharSequence)" ", results);
    }

    public static String scramble(String word) {
        String scrambled;
        if (word.length() <= 1 || StringUtils.getUniqueCharacterCount(word) == 1) {
            return word;
        }
        while ((scrambled = StringUtils.attemptScramble(word)).equals(word)) {
        }
        return scrambled;
    }

    private static String attemptScramble(String word) {
        ArrayList<Integer> usedIndexes = new ArrayList<Integer>();
        char[] chars = new char[word.length()];
        for (char c : word.toCharArray()) {
            int randomIndex = -1;
            while (randomIndex == -1 || usedIndexes.contains(randomIndex)) {
                randomIndex = NumberUtils.randomIntInRange(0, chars.length - 1);
            }
            chars[randomIndex] = c;
            usedIndexes.add(randomIndex);
        }
        return new String(chars);
    }

    private static int getUniqueCharacterCount(String string) {
        HashSet<Character> uniqueCharacters = new HashSet<Character>();
        for (char c : string.toCharArray()) {
            uniqueCharacters.add(Character.valueOf(c));
        }
        return uniqueCharacters.size();
    }

    public static String removeExtraSpaces(String string) {
        return string.replaceAll("\\s+", " ");
    }

    private StringUtils() {
    }
}

