/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.util;

import com.equestricraft.logging.Log;
import java.time.Duration;

public class ThreadUtils {
    private static final String THREAD_NAME_FORMAT = "equestricraft-%s";
    private static final Log log = Log.getLogger(ThreadUtils.class.getName());

    public static void sleep(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException ex) {
            log.error("A thread was interrupted during sleep", ex);
            Thread.currentThread().interrupt();
        }
    }

    public static String threadName(String name) {
        return String.format(THREAD_NAME_FORMAT, name);
    }

    private ThreadUtils() {
    }
}

