/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.util;

import java.util.UUID;
import java.util.regex.Pattern;

public class UuidUtils {
    private static final Pattern UUID_REGEX = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");

    public static UUID stringToUuid(String uuidString) {
        return UUID.fromString(uuidString.replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
    }

    public static void ensureUuidIsValid(String uuidString) {
        if (!UUID_REGEX.matcher(uuidString).matches()) {
            throw new IllegalArgumentException(String.format("Invalid UUID string provided: %s", uuidString));
        }
    }

    private UuidUtils() {
    }
}

