/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.common.version;

import com.equestricraft.common.AsciiArt;
import com.equestricraft.common.version.NotDevBuildException;
import com.equestricraft.logging.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;

public class BuildInformation {
    private static final BuildInformation BUILD_INFORMATION = BuildInformation.createFromFile();
    private static final String VERSION_PROPERTY = "equestricraft.version";
    private static final String DEV_BUILD_PROPERTY = "equestricraft.devBuild";
    private static final String DEBUG_CHAT_OUTPUT = "equestricraft.debugChatOutput";
    private static final String ENTITLEMENT_BASE_URL = "equestricraft.entitlementBaseUrl";
    private static final String ENTITLEMENT_GROUPS = "equestricraft.entitlementGroups";
    private static final String BUILD_TIME = "equestricraft.buildTime";
    private final String versionString;
    private final boolean devBuild;
    private final boolean debugChatOutput;
    private final String entitlementBaseUrl;
    private final String entitlementGroups;
    private final String buildTime;
    private static final Log log = Log.getLogger(BuildInformation.class.getName());

    public static BuildInformation get() {
        return BUILD_INFORMATION;
    }

    public static void printBuildInformation(String containerName) {
        String ascii = AsciiArt.getAsciiFromFile();
        BuildInformation info2 = BuildInformation.get();
        log.info("\n" + ascii);
        log.info("{} v{}", (Object)containerName, (Object)info2.getVersionString());
        if (info2.isDevBuild()) {
            log.info("***This is a development build***");
        }
        if (info2.isDebugChatOutput()) {
            log.info("***Chat output debugging is enabled***");
        }
        if (info2.isEntitlementCheckEnabled()) {
            log.info("***Entitlement checking is enabled***");
            log.info("Entitlement check URL: {}", (Object)info2.getEntitlementBaseUrl());
            log.info("Entitlement check groups: {}", (Object)info2.getEntitlementGroups());
        }
    }

    public static void ensureDevBuild() {
        if (!BUILD_INFORMATION.isDevBuild()) {
            throw new NotDevBuildException();
        }
    }

    private static BuildInformation createFromFile() {
        Properties props = BuildInformation.loadBuildInfoPropertiesFromFile();
        String versionString = props.getProperty(VERSION_PROPERTY);
        if (versionString.equals("_noversion_")) {
            throw new IllegalArgumentException("Version number not set. This could indicate an issue with the build process");
        }
        boolean devBuild = Boolean.parseBoolean(props.getProperty(DEV_BUILD_PROPERTY));
        boolean debugChatOutput = Boolean.parseBoolean(props.getProperty(DEBUG_CHAT_OUTPUT));
        String entitlementBaseUrl = props.getProperty(ENTITLEMENT_BASE_URL);
        String entitlementGroups = props.getProperty(ENTITLEMENT_GROUPS);
        String buildTime = props.getProperty(BUILD_TIME);
        return BuildInformation.create(versionString, devBuild, debugChatOutput, entitlementBaseUrl, entitlementGroups, buildTime);
    }

    private static Properties loadBuildInfoPropertiesFromFile() {
        try {
            InputStream stream = BuildInformation.class.getClassLoader().getResourceAsStream("build-info.properties");
            if (stream == null) {
                throw new IllegalArgumentException(String.format("No %s file found", "build-info.properties"));
            }
            Properties props = new Properties();
            props.load(stream);
            return props;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(String.format("Invalid %s file", "build-info.properties"));
        }
    }

    private static BuildInformation create(String version, boolean devBuild, boolean debugChatOutput, String entitlementBaseUrl, String entitlementGroups, String buildTime) {
        Objects.requireNonNull(version, "Must supply a version");
        return new BuildInformation(version, devBuild, debugChatOutput, entitlementBaseUrl, entitlementGroups, buildTime);
    }

    private BuildInformation(String versionString, boolean devBuild, boolean debugChatOutput, String entitlementBaseUrl, String entitlementGroups, String buildTime) {
        this.versionString = versionString;
        this.devBuild = devBuild;
        this.debugChatOutput = debugChatOutput;
        this.entitlementBaseUrl = entitlementBaseUrl;
        this.entitlementGroups = entitlementGroups;
        this.buildTime = buildTime;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getBaseVersion() {
        if (this.versionString.contains("-")) {
            return this.versionString.split("-")[0];
        }
        return this.versionString;
    }

    public boolean isDevBuild() {
        return this.devBuild;
    }

    public boolean isDebugChatOutput() {
        return this.debugChatOutput;
    }

    public String getEntitlementBaseUrl() {
        return this.entitlementBaseUrl;
    }

    public String getEntitlementGroups() {
        return this.entitlementGroups;
    }

    public boolean isEntitlementCheckEnabled() {
        return !this.getEntitlementBaseUrl().equals("_nocheck_");
    }

    public Date getBuildTime() {
        return new Date(Long.parseLong(this.buildTime));
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + Objects.hashCode(this.versionString);
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildInformation version = (BuildInformation)o;
        return this.versionString.equals(version.versionString);
    }

    public String toString() {
        return this.getVersionString();
    }
}

