/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.agesetting;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.agesetting.AgeSetting;
import com.equestricraft.core.agesetting.AgeSettingProvisionScale;
import com.equestricraft.core.agesetting.AgeSettingValue;
import java.util.List;

public class AgeSettingDatabase
implements RepositoryDatasource<AgeSetting, Integer> {
    @Override
    public List<AgeSetting> retrieveAll() {
        return Query.selectAllFrom("AGE_SETTING").getList(this::getFromResultRow);
    }

    private AgeSetting getFromResultRow(ResultRow row) {
        int ageMonths = row.getInt("AGE_MONTHS");
        Double stallionWeightPercentage = row.getNullableDouble("STALLION_PERCENTAGE_OF_WEIGHT");
        Double mareWeightPercentage = row.getNullableDouble("MARE_PERCENTAGE_OF_WEIGHT");
        AgeSettingValue weight = new AgeSettingValue(stallionWeightPercentage, mareWeightPercentage);
        Double stallionHeightPercentage = row.getNullableDouble("STALLION_PERCENTAGE_OF_HEIGHT");
        Double mareHeightPercentage = row.getNullableDouble("MARE_PERCENTAGE_OF_HEIGHT");
        AgeSettingValue height = new AgeSettingValue(stallionHeightPercentage, mareHeightPercentage);
        Double stallionProvisionScaleSize = row.getNullableDouble("STALLION_PROVISION_SCALE_SIZE");
        Double mareProvisionScaleSize = row.getNullableDouble("MARE_PROVISION_SCALE_SIZE");
        AgeSettingValue provisionScaleSize = new AgeSettingValue(stallionProvisionScaleSize, mareProvisionScaleSize);
        Double stallionProvisionScaleHours = row.getNullableDouble("STALLION_PROVISION_SCALE_HOURS");
        Double mareProvisionScaleHours = row.getNullableDouble("MARE_PROVISION_SCALE_HOURS");
        AgeSettingValue provisionScaleHours = new AgeSettingValue(stallionProvisionScaleHours, mareProvisionScaleHours);
        AgeSettingProvisionScale provisionScale = new AgeSettingProvisionScale(provisionScaleSize, provisionScaleHours);
        Double stallionHeartRate = row.getNullableDouble("STALLION_HEART_RATE");
        Double mareHeartRate = row.getNullableDouble("MARE_HEART_RATE");
        AgeSettingValue heartRate = new AgeSettingValue(stallionHeartRate, mareHeartRate);
        Double stallionMaximumStaminaPercentage = row.getNullableDouble("STALLION_MAXIMUM_STAMINA_PERCENTAGE");
        Double mareMaximumStaminaPercentage = row.getNullableDouble("MARE_MAXIMUM_STAMINA_PERCENTAGE");
        AgeSettingValue stamina = new AgeSettingValue(stallionMaximumStaminaPercentage, mareMaximumStaminaPercentage);
        return new AgeSetting(ageMonths, weight, height, provisionScale, heartRate, stamina);
    }
}

