/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.agesetting;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.agesetting.AgeSetting;
import com.equestricraft.core.agesetting.AgeSettingRepository;
import com.equestricraft.core.agesetting.AgeSettingSession;
import com.equestricraft.core.agesetting.AgeSettingValue;
import com.equestricraft.core.agesetting.ProvisionScaleAge;
import com.equestricraft.core.horse.EQHorse;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class AgeSettingSessionImpl
implements AgeSettingSession {
    @Service
    private AgeSettingRepository ageSettingRepository;

    @Override
    public double getFinalWeightPercentage(EQHorse horse) {
        return this.getValueForHorse(horse, AgeSetting::getWeight);
    }

    @Override
    public double getFinalHeightPercentage(EQHorse horse) {
        return this.getValueForHorse(horse, AgeSetting::getHeight);
    }

    @Override
    public ProvisionScaleAge getProvisionScale(EQHorse horse) {
        double size = this.getValueForHorse(horse, a -> a.getProvisionScale().getSize());
        double hours = this.getValueForHorse(horse, a -> a.getProvisionScale().getHours());
        return new ProvisionScaleAge(size, hours);
    }

    @Override
    public double getHeartRate(EQHorse horse) {
        return this.getValueForHorse(horse, AgeSetting::getHeartRate);
    }

    @Override
    public double getMaximumStaminaPercentage(EQHorse horse) {
        return this.getValueForHorse(horse, AgeSetting::getStamina);
    }

    private double getValueForHorse(EQHorse horse, Function<AgeSetting, AgeSettingValue> valueGetter) {
        int ageMonths = horse.getAge().getMonths();
        List<AgeValue> allValues = this.getValidAgeValues(horse, valueGetter);
        AgeValuePair pair = this.getPairForAge(ageMonths, allValues);
        return this.calculateValueForAge(ageMonths, pair);
    }

    private List<AgeValue> getValidAgeValues(EQHorse horse, Function<AgeSetting, AgeSettingValue> valueGetter) {
        List allSettings = this.ageSettingRepository.findAll();
        List<AgeValue> values2 = allSettings.stream().filter(s -> this.getValue((AgeSettingValue)valueGetter.apply((AgeSetting)s), horse) != null).sorted(Comparator.comparingInt(AgeSetting::getAgeMonths)).map(a -> new AgeValue(a.getAgeMonths(), this.getValue((AgeSettingValue)valueGetter.apply((AgeSetting)a), horse))).toList();
        if (values2.isEmpty()) {
            throw new IllegalArgumentException("No age settings configured for this field");
        }
        return values2;
    }

    private Double getValue(AgeSettingValue container, EQHorse horse) {
        return container.getForGender(horse.getHorseGender());
    }

    private AgeValuePair getPairForAge(Integer ageMonths, List<AgeValue> ageValues) {
        AgeValue lowValue = ageValues.get(0);
        AgeValue highValue = null;
        for (AgeValue ageValue : ageValues) {
            if (lowValue == null) {
                lowValue = ageValue;
                continue;
            }
            if (ageValue.ageMonths() > ageMonths) {
                lowValue = ageValue;
                continue;
            }
            highValue = ageValue;
        }
        return new AgeValuePair(lowValue, highValue);
    }

    private double calculateValueForAge(Integer ageMonths, AgeValuePair pair) {
        AgeValue lowValue = pair.lower();
        AgeValue highValue = pair.higher() != null ? pair.higher() : lowValue;
        int yearsIntoCurrent = ageMonths - lowValue.ageMonths();
        int endYearsOfCurrent = highValue.ageMonths() - lowValue.ageMonths();
        if (endYearsOfCurrent == 0) {
            return lowValue.value();
        }
        float percentage = (float)yearsIntoCurrent / (float)endYearsOfCurrent;
        double valueDifference = highValue.value() - lowValue.value();
        double percentageToAddToLowest = valueDifference * (double)percentage;
        return lowValue.value() + percentageToAddToLowest;
    }

    private record AgeValuePair(AgeValue lower, AgeValue higher) {
    }

    private record AgeValue(int ageMonths, double value) {
    }
}

