/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.allele;

import com.equestricraft.api.common.APIAlleleDto;
import com.equestricraft.api.common.APIAllelesDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.allele.Allele;
import com.equestricraft.core.allele.AlleleConfig;
import com.equestricraft.core.allele.AlleleTransformer;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class APIAllelesDtoImpl
extends MapAdapter<String, APIAlleleDto>
implements APIAllelesDto {
    @Service
    private static AlleleTransformer alleleTransformer;

    @Override
    public int size() {
        return Allele.values().length;
    }

    @Override
    public APIAlleleDto get(Object key) {
        Allele allele = Allele.getAllele(key.toString());
        AlleleConfig alleleConfig = allele.getConfig();
        return alleleTransformer.toDto(alleleConfig);
    }

    @Override
    public Set<Map.Entry<String, APIAlleleDto>> entrySet() {
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<String, APIAlleleDto>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, APIAlleleDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return APIAllelesDtoImpl.this.size();
        }

        final class EntrySetIterator
        implements Iterator<Map.Entry<String, APIAlleleDto>> {
            private int currentIndex = 0;

            EntrySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return EntrySet.this.size() > this.currentIndex;
            }

            @Override
            public Map.Entry<String, APIAlleleDto> next() {
                if (this.hasNext()) {
                    Allele allele = Allele.values()[this.currentIndex++];
                    APIAlleleDto dto = alleleTransformer.toDto(allele.getConfig());
                    return Map.entry(allele.name(), dto);
                }
                throw new NoSuchElementException();
            }
        }
    }
}

