/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.allele;

import com.equestricraft.core.allele.AlleleConfig;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Stream;

public enum Allele {
    EXTENSION,
    AGOUTI,
    CREAM,
    DUN,
    SILVER,
    GRAY,
    ROAN,
    SABINO,
    TOBIANO,
    OVERO,
    SPLASHED_WHITE,
    LEOPARD,
    DMRT3,
    CHAMPAGNE,
    PATN1;

    private AlleleConfig config = null;

    public AlleleConfig getConfig() {
        return this.config;
    }

    void setConfig(AlleleConfig config) {
        this.config = config;
    }

    public int getId() {
        return this.getConfig().getId();
    }

    public String getDisplayName() {
        return this.getConfig().getName();
    }

    public String getDescription() {
        return this.getConfig().getDescription();
    }

    public int getDisplayOrder() {
        return this.getConfig().getDisplayOrder();
    }

    public String getDominantDisplay() {
        return this.getConfig().getDominantDisplay();
    }

    public String getRecessiveDisplay() {
        return this.getConfig().getRecessiveDisplay();
    }

    public static Stream<Allele> stream() {
        return Arrays.stream(Allele.values()).sorted(Comparator.comparingInt(Allele::getDisplayOrder));
    }

    public static Allele getAllele(String name) {
        for (Allele allele : Allele.values()) {
            if (!allele.name().equalsIgnoreCase(name)) continue;
            return allele;
        }
        throw new IllegalArgumentException(String.format("Invalid allele: %s", name));
    }
}

