/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.allele;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.core.allele.Allele;
import java.util.Objects;

public class AlleleConfig
implements RepositoryEntity<Integer> {
    private final int id;
    private final Allele identifier;
    private final String name;
    private final String description;
    private final int displayOrder;
    private final String dominantDisplay;
    private final String recessiveDisplay;

    public AlleleConfig(int id, Allele identifier, String name, String description, int displayOrder, String dominantDisplay, String recessiveDisplay) {
        this.id = id;
        this.identifier = identifier;
        this.name = name;
        this.description = description;
        this.displayOrder = displayOrder;
        this.dominantDisplay = dominantDisplay;
        this.recessiveDisplay = recessiveDisplay;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public Allele getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public String getDominantDisplay() {
        return this.dominantDisplay;
    }

    public String getRecessiveDisplay() {
        return this.recessiveDisplay;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlleleConfig allele = (AlleleConfig)o;
        return this.id == allele.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.name;
    }
}

