/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.allele;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.allele.Allele;
import com.equestricraft.core.allele.AlleleConfig;
import java.util.List;

public class AlleleDatabase
implements RepositoryDatasource<AlleleConfig, Integer> {
    @Override
    public List<AlleleConfig> retrieveAll() {
        return Query.selectAllFrom("ALLELE").getList(this::getFromResultRow);
    }

    private AlleleConfig getFromResultRow(ResultRow row) {
        int id = row.getInt("ID");
        Allele allele = row.getEnum("IDENTIFIER", Allele.class);
        String name = row.getString("NAME");
        String description = row.getString("DESCRIPTION");
        int displayOrder = row.getInt("DISPLAY_ORDER");
        String dominantDisplay = row.getString("DOMINANT_DISPLAY");
        String recessiveDisplay = row.getString("RECESSIVE_DISPLAY");
        return new AlleleConfig(id, allele, name, description, displayOrder, dominantDisplay, recessiveDisplay);
    }
}

