/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.approval;

import com.equestricraft.base.response.Response;
import com.equestricraft.base.response.ResponseFactory;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.approval.PlayerApprovalRunnable;
import com.equestricraft.core.approval.PlayerPendingApproval;
import com.equestricraft.core.approval.PlayerPendingApprovalCache;
import com.equestricraft.core.player.ECPlayer;
import java.util.concurrent.CompletableFuture;

public class PlayerApprovalHandler {
    private static final PlayerApprovalHandler instance = new PlayerApprovalHandler();
    private final PlayerPendingApprovalCache playerPendingApprovalCache = PlayerPendingApprovalCache.getInstance();

    public static PlayerApprovalHandler getInstance() {
        return instance;
    }

    private PlayerApprovalHandler() {
    }

    public Response executeWithApproval(ECPlayer sourcePlayer, ECPlayer targetPlayer, String message, PlayerApprovalRunnable action) {
        if (sourcePlayer.equals(targetPlayer)) {
            return action.execute();
        }
        if (!targetPlayer.isOnline()) {
            return ResponseFactory.fail(I18n.getLabel("player.not-online"));
        }
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        PlayerPendingApproval newApproval = new PlayerPendingApproval(sourcePlayer, message, action, future);
        this.playerPendingApprovalCache.add(targetPlayer, newApproval);
        targetPlayer.sendMessage(I18n.getLabel("pending-approval.you-have-pending-approval", sourcePlayer.getIgn(), message, "/pending-approvals"));
        sourcePlayer.sendMessage(I18n.getLabel("pending-approval.waiting-for-approval", targetPlayer.getIgn()));
        return ResponseFactory.future(future);
    }
}

