/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.approval;

import com.equestricraft.common.ListMap;
import com.equestricraft.core.approval.PlayerPendingApproval;
import com.equestricraft.core.player.ECPlayer;
import java.util.List;
import java.util.UUID;

public class PlayerPendingApprovalCache {
    private static final PlayerPendingApprovalCache instance = new PlayerPendingApprovalCache();
    private final ListMap<UUID, PlayerPendingApproval> pendingApprovals = new ListMap();

    public static PlayerPendingApprovalCache getInstance() {
        return instance;
    }

    private PlayerPendingApprovalCache() {
    }

    public synchronized void add(ECPlayer player, PlayerPendingApproval playerPendingApproval) {
        this.pendingApprovals.add(player.getAccountUuid(), playerPendingApproval);
    }

    public synchronized PlayerPendingApproval getApprovalForPlayer(ECPlayer player, UUID uuid) {
        List<PlayerPendingApproval> playersApprovals = this.pendingApprovals.get(player.getAccountUuid());
        return playersApprovals.stream().filter(a -> a.getUuid().equals(uuid)).findFirst().orElseThrow();
    }

    public synchronized void removeApprovalForPlayer(ECPlayer player, PlayerPendingApproval approval) {
        this.pendingApprovals.remove(player.getAccountUuid(), approval);
    }

    public synchronized List<PlayerPendingApproval> getApprovalsForPlayer(ECPlayer player) {
        return this.pendingApprovals.get(player.getAccountUuid());
    }
}

