/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.attribute;

import com.equestricraft.api.common.APIAttributeValueDto;
import com.equestricraft.core.attribute.AttributeAccessor;

public class APIAttributeValueDtoImpl
implements APIAttributeValueDto {
    private final AttributeAccessor attributeAccessor;
    private final String identifier;

    public APIAttributeValueDtoImpl(AttributeAccessor attributeAccessor, String identifier) {
        this.attributeAccessor = attributeAccessor;
        this.identifier = identifier;
    }

    @Override
    public Object getValue() {
        return this.attributeAccessor.get(this.identifier);
    }

    @Override
    public String getStringValue() {
        Object value = this.getValue();
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public Integer getIntValue() {
        Object value = this.getValue();
        if (value != null) {
            return Integer.parseInt(value.toString());
        }
        return null;
    }

    @Override
    public Double getDoubleValue() {
        Object value = this.getValue();
        if (value != null) {
            return Double.parseDouble(value.toString());
        }
        return null;
    }

    @Override
    public Long getLongValue() {
        Object value = this.getValue();
        if (value != null) {
            return Long.parseLong(value.toString());
        }
        return null;
    }

    @Override
    public Float getFloatValue() {
        Object value = this.getValue();
        if (value != null) {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        return null;
    }

    @Override
    public Boolean getBooleanValue() {
        Object value = this.getValue();
        if (value != null) {
            return Boolean.parseBoolean(value.toString());
        }
        return null;
    }

    @Override
    public void setValue(Object value) {
        this.attributeAccessor.put(this.identifier, value);
    }

    @Override
    public boolean isTrue() {
        return this.attributeAccessor.isTrue(this.identifier);
    }

    @Override
    public boolean isFalse() {
        return !this.isTrue();
    }

    @Override
    public String getDisplayValue() {
        return this.attributeAccessor.getDisplayValue(this.identifier);
    }

    public String toString() {
        return this.getDisplayValue();
    }
}

