/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.attribute;

import java.time.Duration;
import java.util.Date;

public abstract class AttributeValueAccessor {
    private final String value;

    protected AttributeValueAccessor(String value) {
        this.value = value;
    }

    public String getString() {
        return this.value;
    }

    public Byte getByte() {
        return this.value != null ? Byte.valueOf(Byte.parseByte(this.value)) : null;
    }

    public Short getShort() {
        return this.value != null ? Short.valueOf(Short.parseShort(this.value)) : null;
    }

    public Integer getInt() {
        return this.value != null ? Integer.valueOf(Integer.parseInt(this.value)) : null;
    }

    public Long getLong() {
        return this.value != null ? Long.valueOf(Long.parseLong(this.value)) : null;
    }

    public Float getFloat() {
        return this.value != null ? Float.valueOf(Float.parseFloat(this.value)) : null;
    }

    public Double getDouble() {
        return this.value != null ? Double.valueOf(Double.parseDouble(this.value)) : null;
    }

    public Boolean getBoolean() {
        return this.value != null ? Boolean.valueOf(Boolean.parseBoolean(this.value)) : null;
    }

    public Character getCharacter() {
        return this.value != null && !this.value.isEmpty() ? Character.valueOf(this.value.charAt(0)) : null;
    }

    public Date getDate() {
        Long longValue = this.getLong();
        return longValue != null ? new Date(longValue) : null;
    }

    public Duration getDuration() {
        Long longValue = this.getLong();
        return longValue != null ? Duration.ofMillis(longValue) : null;
    }

    public String toString() {
        return this.getString();
    }
}

