/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.attribute.player;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.attribute.player.PlayerAttribute;
import java.util.List;

public class PlayerAttributeDatabase
implements RepositoryDatasource<PlayerAttribute, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_NAME = "NAME";
    private static final String COLUMN_IDENTIFIER = "IDENTIFIER";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_TRUE_CONDITION_SCRIPT = "TRUE_CONDITION_SCRIPT";
    private static final String COLUMN_DISPLAY_SCRIPT = "DISPLAY_SCRIPT";
    private static final String COLUMN_PUBLISHED = "PUBLISHED";

    @Override
    public List<PlayerAttribute> retrieveAll() {
        return Query.selectAllFrom("PLAYER_ATTRIBUTE").where(QueryColumn.column(COLUMN_PUBLISHED, true)).getList(this::getFromResultRow);
    }

    private PlayerAttribute getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        String name = row.getString(COLUMN_NAME);
        String identifier = row.getString(COLUMN_IDENTIFIER);
        String description = row.getString(COLUMN_DESCRIPTION);
        String trueConditionString = row.getString(COLUMN_TRUE_CONDITION_SCRIPT);
        String displayScript = row.getString(COLUMN_DISPLAY_SCRIPT);
        return new PlayerAttribute(id, name, identifier, description, trueConditionString, displayScript);
    }
}

