/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.ban;

import com.equestricraft.base.database.DatabaseException;
import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.core.ban.Ban;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Optional;

public class BanDatabase {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_PLAYER_ID = "PLAYER_ID";
    private static final String COLUMN_IP_ADDRESS = "IP_ADDRESS";
    private static final String COLUMN_BANNED_BY_PLAYER_ID = "BANNED_BY_PLAYER_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_EXPIRY_TIME = "EXPIRY_TIME";
    private static final String COLUMN_REASON = "REASON";
    private static final String COLUMN_ACTIVE = "ACTIVE";

    public Ban add(Ban ban) {
        Query.insertInto("BAN").columns(QueryColumn.column(COLUMN_PLAYER_ID, ban.getPlayerId()), QueryColumn.column(COLUMN_IP_ADDRESS, ban.getIpAddress()), QueryColumn.column(COLUMN_BANNED_BY_PLAYER_ID, ban.getBannedByPlayerId()), QueryColumn.column(COLUMN_TIME_STAMP, ban.getTimeStamp()), QueryColumn.column(COLUMN_EXPIRY_TIME, ban.getExpiryTime()), QueryColumn.column(COLUMN_REASON, ban.getReason()), QueryColumn.column(COLUMN_ACTIVE, ban.isActive())).executeGetGeneratedKey(ban::setId);
        return ban;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Ban> getMostRecentActiveBanForPlayer(int playerId) {
        try (PreparedStatement statement = Query.prepare(String.format("SELECT * FROM %s WHERE %s = TRUE AND %s = ? AND (%s IS NULL OR %s > ?)", "BAN", COLUMN_ACTIVE, COLUMN_PLAYER_ID, COLUMN_EXPIRY_TIME, COLUMN_EXPIRY_TIME));){
            statement.setInt(1, playerId);
            statement.setLong(2, System.currentTimeMillis());
            ResultSet set2 = statement.executeQuery();
            if (set2.next()) {
                Optional<Ban> optional2 = Optional.of(this.getFromResultSet(set2));
                return optional2;
            }
            Optional<Ban> optional = Optional.empty();
            return optional;
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Ban> getMostRecentActiveBanForIpAddress(String ipAddress) {
        try (PreparedStatement statement = Query.prepare(String.format("SELECT * FROM %s WHERE %s = TRUE AND %s = ? AND (%s IS NULL OR %s > ?)", "BAN", COLUMN_ACTIVE, COLUMN_IP_ADDRESS, COLUMN_EXPIRY_TIME, COLUMN_EXPIRY_TIME));){
            statement.setString(1, ipAddress);
            statement.setLong(2, System.currentTimeMillis());
            ResultSet set2 = statement.executeQuery();
            if (set2.next()) {
                Optional<Ban> optional2 = Optional.of(this.getFromResultSet(set2));
                return optional2;
            }
            Optional<Ban> optional = Optional.empty();
            return optional;
        }
        catch (SQLException ex) {
            throw new DatabaseException(ex);
        }
    }

    public void pardonPlayer(int playerId) {
        Query.update("BAN").set(QueryColumn.column(COLUMN_ACTIVE, false)).where(QueryColumn.column(COLUMN_PLAYER_ID, playerId)).execute();
    }

    public void pardonIpAddress(String ipAddress) {
        Query.update("BAN").set(QueryColumn.column(COLUMN_ACTIVE, false)).where(QueryColumn.column(COLUMN_IP_ADDRESS, ipAddress)).execute();
    }

    private Ban getFromResultSet(ResultSet set2) throws SQLException {
        int id = set2.getInt(COLUMN_ID);
        Integer playerId = null;
        int playerIdTemp = set2.getInt(COLUMN_PLAYER_ID);
        if (!set2.wasNull()) {
            playerId = playerIdTemp;
        }
        String ipAddress = set2.getString(COLUMN_IP_ADDRESS);
        int bannedByPlayerId = set2.getInt(COLUMN_BANNED_BY_PLAYER_ID);
        Date timeStamp = new Date(set2.getLong(COLUMN_TIME_STAMP));
        Date expiryTime = null;
        long expiryTimeT = set2.getLong(COLUMN_EXPIRY_TIME);
        if (!set2.wasNull()) {
            expiryTime = new Date(expiryTimeT);
        }
        String reason = set2.getString(COLUMN_REASON);
        boolean active = set2.getBoolean(COLUMN_ACTIVE);
        return new Ban(id, playerId, ipAddress, bannedByPlayerId, timeStamp, expiryTime, reason, active);
    }
}

