/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.ban;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.ban.Ban;
import com.equestricraft.core.ban.BanDatabase;
import com.equestricraft.core.ban.BanInfo;
import com.equestricraft.core.ban.BanSession;
import com.equestricraft.core.player.ECPlayer;
import java.util.Date;
import java.util.Optional;

public class BanSessionImpl
implements BanSession {
    @Service
    private BanDatabase banDatabase;

    @Override
    public void banPlayer(ECPlayer player, ECPlayer bannedBy, Integer days, String reason) {
        Date expiry = this.calculateExpiry(days);
        Ban ban = new Ban(0, player.getId(), null, bannedBy.getId(), new Date(), expiry, reason, true);
        this.banDatabase.add(ban);
    }

    @Override
    public void banIpAddress(String ipAddress, ECPlayer bannedBy, Integer days, String reason) {
        Date expiry = this.calculateExpiry(days);
        Ban ban = new Ban(0, null, ipAddress, bannedBy.getId(), new Date(), expiry, reason, true);
        this.banDatabase.add(ban);
    }

    @Override
    public Optional<BanInfo> findPlayersCurrentBan(ECPlayer player) {
        Optional<Ban> ban = this.banDatabase.getMostRecentActiveBanForPlayer(player.getId());
        return ban.map(this::buildBanInfo);
    }

    @Override
    public Optional<BanInfo> findIpAddressesCurrentBan(String ipAddress) {
        Optional<Ban> ban = this.banDatabase.getMostRecentActiveBanForIpAddress(ipAddress);
        return ban.map(this::buildBanInfo);
    }

    @Override
    public void pardonPlayer(ECPlayer player) {
        this.banDatabase.pardonPlayer(player.getId());
    }

    @Override
    public void pardonIpAddress(String ipAddress) {
        this.banDatabase.pardonIpAddress(ipAddress);
    }

    private Date calculateExpiry(Integer days) {
        if (days == null) {
            return null;
        }
        return DateUtils.futureDaysOffset(days);
    }

    private BanInfo buildBanInfo(Ban ban) {
        Integer daysLeft = this.calculateDaysLeft(ban.getExpiryTime());
        return new BanInfo(daysLeft, ban.getReason());
    }

    private Integer calculateDaysLeft(Date expiry) {
        if (expiry == null) {
            return null;
        }
        return DateUtils.daysUntil(expiry);
    }
}

