/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.bit;

import com.equestricraft.api.common.APIBitDto;
import com.equestricraft.api.common.APIBitsDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.bit.HorseBit;
import com.equestricraft.core.bit.HorseBitRepository;
import com.equestricraft.core.bit.HorseBitTransformer;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class APIBitsDtoImpl
extends MapAdapter<String, APIBitDto>
implements APIBitsDto {
    @Service
    private static HorseBitRepository horseBitRepository;
    @Service
    private static HorseBitTransformer horseBitTransformer;

    @Override
    public int size() {
        return horseBitRepository.getTotalSize();
    }

    @Override
    public APIBitDto get(Object key) {
        Optional<HorseBit> bit = this.findByKey(key);
        return bit.map(horseBitTransformer::toApiDto).orElse(null);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findByKey(key).isPresent();
    }

    private Optional<HorseBit> findByKey(Object key) {
        if (key instanceof String) {
            String identifier = (String)key;
            return horseBitRepository.findByIdentifier(identifier);
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            return horseBitRepository.findByKeyIfExists(id);
        }
        throw new IllegalArgumentException("Invalid key provided");
    }

    @Override
    public Set<Map.Entry<String, APIBitDto>> entrySet() {
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<String, APIBitDto>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, APIBitDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return APIBitsDtoImpl.this.size();
        }

        static final class EntrySetIterator
        implements Iterator<Map.Entry<String, APIBitDto>> {
            private final Iterator<HorseBit> iterator = horseBitRepository.iterator();

            EntrySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<String, APIBitDto> next() {
                HorseBit next = this.iterator.next();
                APIBitDto dto = horseBitTransformer.toApiDto(next);
                return Map.entry(next.getIdentifier(), dto);
            }
        }
    }
}

